package gov.va.med.domain.service.messaging;

import gov.va.med.domain.service.messaging.handler.RecoverableHandlerException;
import gov.va.med.domain.service.messaging.handler.UnrecoverableHandlerException;
import gov.va.med.domain.service.messaging.parse.HL7MessageMetadata;

/**
 * @author Slava Uchitel
 * @version $Id: IHL7MessageProcessor.java,v 1.6 2005/09/20 13:24:09 slava.uchitel Exp $
 * @since MHV 2.0 <br>03/18/2005
 */
public interface IHL7MessageProcessor {
	/**
	 * Main method to coordinante all message processing.
	 * If any exceptions other than recoverable are thrwon, they are logged as errors and
	 * processing halts.
	 *
	 * @param message
	 * @throws RecoverableHandlerException
	 * @throws UnrecoverableHandlerException
	 * @throws RuntimeException
	 */
	public void processMessage(String message)
	    throws RecoverableHandlerException, UnrecoverableHandlerException;
	
	/**
	 * Saves messaging request with PE status. 
	 * @throws MessagingException
	 */
	public void setRequestStatusFailed() throws MessagingException;
	
	/**
	 * Made public so Message Driven Bean can call from catch clause to pass into error queue.
	 */
	public HL7MessageMetadata getMetaData();

}